/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.inventory.container;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.ValueNotifierHelpers;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.PartStateException;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.network.PartNetworkElement;

public class ContainerPartSettings
extends InventoryContainer {
    public static final String BUTTON_SAVE = "button_save";
    public static final String BUTTON_SETTINGS = "button_settings";
    private static final int PAGE_SIZE = 3;
    private final PartTarget target;
    private final Optional<IPartContainer> partContainer;
    private final IPartType partType;
    private final Level world;
    private final int lastUpdateValueId;
    private final int lastPriorityValueId;
    private final int lastChannelValueId;
    private final int lastSideValueId;
    private final int lastMinUpdateValueId;

    public ContainerPartSettings(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, (Container)new SimpleContainer(0), PartHelpers.readPartTarget(packetBuffer), Optional.empty(), (IPartType)PartHelpers.readPart(packetBuffer));
    }

    public ContainerPartSettings(int id, Inventory playerInventory, Container inventory, PartTarget target, Optional<IPartContainer> partContainer, IPartType partType) {
        this(RegistryEntries.CONTAINER_PART_SETTINGS, id, playerInventory, inventory, target, partContainer, partType);
    }

    public ContainerPartSettings(@Nullable MenuType<?> type, int id, Inventory playerInventory, Container inventory, PartTarget target, Optional<IPartContainer> partContainer, IPartType partType) {
        super(type, id, playerInventory, inventory);
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.world = this.player.m_20193_();
        this.addPlayerInventory(this.player.m_150109_(), 27, this.getPlayerInventoryOffsetY());
        this.lastUpdateValueId = this.getNextValueId();
        this.lastPriorityValueId = this.getNextValueId();
        this.lastChannelValueId = this.getNextValueId();
        this.lastSideValueId = this.getNextValueId();
        this.lastMinUpdateValueId = this.getNextValueId();
        this.putButtonAction(BUTTON_SAVE, (s, containerExtended) -> {
            if (!this.world.m_5776_()) {
                PartHelpers.openContainerPart((ServerPlayer)this.player, target.getCenter(), this.getPartType());
            }
        });
    }

    public IPartType getPartType() {
        return this.partType;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public int getLastChannelValueId() {
        return this.lastChannelValueId;
    }

    public int getLastPriorityValueId() {
        return this.lastPriorityValueId;
    }

    public int getLastSideValueId() {
        return this.lastSideValueId;
    }

    public int getLastUpdateValueId() {
        return this.lastUpdateValueId;
    }

    public int getLastMinUpdateValueId() {
        return this.lastMinUpdateValueId;
    }

    protected int getPlayerInventoryOffsetY() {
        return 107;
    }

    protected void initializeValues() {
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastUpdateValueId, (int)this.getPartType().getUpdateInterval(this.getPartState()));
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastPriorityValueId, (int)this.getPartType().getPriority(this.getPartState()));
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastChannelValueId, (int)this.getPartType().getChannel(this.getPartState()));
        Direction targetSide = this.getPartType().getTargetSideOverride(this.getPartState());
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastSideValueId, (int)(targetSide == null ? -1 : targetSide.ordinal()));
        ValueNotifierHelpers.setValue((IValueNotifier)this, (int)this.lastMinUpdateValueId, (int)this.getPartType().getMinimumUpdateInterval(this.getPartState()));
    }

    public int getLastUpdateValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastUpdateValueId);
    }

    public int getLastPriorityValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastPriorityValueId);
    }

    public int getLastChannelValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastChannelValueId);
    }

    public int getLastSideValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastSideValueId);
    }

    public int getLastMinUpdateValue() {
        return ValueNotifierHelpers.getValueInt((IValueNotifier)this, (int)this.lastMinUpdateValueId);
    }

    public IPartState getPartState() {
        return this.partContainer.get().getPartState(this.getTarget().getCenter().getSide());
    }

    public boolean m_6875_(Player player) {
        return PartHelpers.canInteractWith(this.getTarget(), player, this.partContainer.get());
    }

    protected int getSizeInventory() {
        return 0;
    }

    public void onUpdate(int valueId, CompoundTag value) {
        super.onUpdate(valueId, value);
        try {
            if (!this.world.m_5776_()) {
                PartTarget target = this.getTarget();
                DimPos dimPos = target.getCenter().getPos();
                INetwork network = NetworkHelpers.getNetworkChecked((BlockGetter)dimPos.getLevel(true), dimPos.getBlockPos(), target.getCenter().getSide());
                this.updatePartSettings();
                if (this.getPartState().getTargetSideOverride() != null) {
                    target = target.forTargetSide(this.getPartState().getTargetSideOverride());
                }
                PartNetworkElement networkElement = new PartNetworkElement(this.getPartType(), target);
                network.setPriorityAndChannel(networkElement, this.getLastPriorityValue(), this.getLastChannelValue());
            }
        }
        catch (PartStateException e) {
            this.player.m_6915_();
        }
    }

    protected void updatePartSettings() {
        this.getPartType().setUpdateInterval(this.getPartState(), this.getLastUpdateValue());
        Direction targetSide = this.getLastSideValue() >= 0 ? Direction.values()[this.getLastSideValue()] : null;
        this.getPartType().setTargetSideOverride(this.getPartState(), targetSide);
    }
}

